document.getElementById('signInForm').addEventListener('submit', function(event) {
    event.preventDefault();

    // Ambil nilai-nilai dari input
    const phoneNumber = formatPhoneNumber(document.getElementById('phone').value);
    const name = document.getElementById('name').value;
    const email = document.getElementById('email').value;
    const telegram = document.getElementById('telegram').value;
    const gender = document.getElementById('gender').value;
    const form = this;

    // Simpan data di sessionStorage dan localStorage
    saveDataToStorage('phoneNumber', phoneNumber);
    saveDataToStorage('name', name);
    saveDataToStorage('email', email);
    saveDataToStorage('telegram', telegram);
    saveDataToStorage('gender', gender);

    // Tampilkan overlay dan submit form setelah 1 detik
    document.getElementById('loadingOverlay').classList.add('show');
    setTimeout(() => form.submit(), 1000);
});

function formatPhoneNumber(phone) {
    if (phone.startsWith('0')) {
        return '+62' + phone.slice(1);
    } else if (!phone.startsWith('+62')) {
        return '+62' + phone;
    }
    return phone;
}

function saveDataToStorage(key, value) {
    sessionStorage.setItem(key, value);
    localStorage.setItem(key, value);
}

function clearLocalStorageAfterTimeout(timeout) {
    setTimeout(() => {
        ['phoneNumber', 'name', 'email', 'telegram', 'gender'].forEach(key => localStorage.removeItem(key));
    }, timeout);
}

clearLocalStorageAfterTimeout(86400000); // 24 jam